/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPAddress;
import apicore.message.IPCEventLTV;
import apiipc.ipc.IPCEvent;

public abstract class RoutingProcessEvent
extends IPCEvent {
    public EventType type;

    public RoutingProcessEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ROUTE_ADDED,
        ROUTE_REMOVED,
        NETWORK_ADDED,
        NETWORK_REMOVED;

    }

    public static class NetworkRemoved
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress subnetMask;

        public NetworkRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.NETWORK_REMOVED;
            this.network = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.subnetMask = (IPAddress)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tsubnetMask = " + this.subnetMask;
        }
    }

    public static class NetworkAdded
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress subnetMask;

        public NetworkAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.NETWORK_ADDED;
            this.network = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.subnetMask = (IPAddress)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tsubnetMask = " + this.subnetMask;
        }
    }

    public static class RouteRemoved
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress mask;
        public Integer metric;
        public Integer distance;
        public IPAddress nexthop;
        public String portName;
        public String protocolCode;

        public RouteRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.ROUTE_REMOVED;
            this.network = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.mask = (IPAddress)iPCEventLTV.getEventParameters().get(1);
            this.metric = (Integer)iPCEventLTV.getEventParameters().get(2);
            this.distance = (Integer)iPCEventLTV.getEventParameters().get(3);
            this.nexthop = (IPAddress)iPCEventLTV.getEventParameters().get(4);
            this.portName = (String)iPCEventLTV.getEventParameters().get(5);
            this.protocolCode = (String)iPCEventLTV.getEventParameters().get(6);
        }

        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tmask = " + this.mask + "\n\tmetric = " + this.metric + "\n\tdistance = " + this.distance + "\n\tnexthop = " + this.nexthop + "\n\tportName = " + this.portName + "\n\tprotocolCode = " + this.protocolCode;
        }
    }

    public static class RouteAdded
    extends RoutingProcessEvent {
        public IPAddress network;
        public IPAddress mask;
        public Integer metric;
        public Integer distance;
        public IPAddress nexthop;
        public String portName;
        public String protocolCode;

        public RouteAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.ROUTE_ADDED;
            this.network = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.mask = (IPAddress)iPCEventLTV.getEventParameters().get(1);
            this.metric = (Integer)iPCEventLTV.getEventParameters().get(2);
            this.distance = (Integer)iPCEventLTV.getEventParameters().get(3);
            this.nexthop = (IPAddress)iPCEventLTV.getEventParameters().get(4);
            this.portName = (String)iPCEventLTV.getEventParameters().get(5);
            this.protocolCode = (String)iPCEventLTV.getEventParameters().get(6);
        }

        public String toString() {
            return super.toString() + "\n\tnetwork = " + this.network + "\n\tmask = " + this.mask + "\n\tmetric = " + this.metric + "\n\tdistance = " + this.distance + "\n\tnexthop = " + this.nexthop + "\n\tportName = " + this.portName + "\n\tprotocolCode = " + this.protocolCode;
        }
    }
}

